/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.inferencing.IRequireResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireResolverFactory {
    private static List<IRequireResolver> fgProxies;

    private static synchronized List<IRequireResolver> getResolvers() {
        if (fgProxies == null) {
            final ArrayList proxies = new ArrayList();
            EclipseUtil.processConfigurationElements((String)"com.aptana.js.core", (String)"requireResolvers", (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    proxies.add(new ResolverProxy(element));
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{"resolver"});
                }
            });
            Collections.sort(proxies);
            fgProxies = CollectionsUtil.map(proxies, (IMap)new IMap<ResolverProxy, IRequireResolver>(){

                public IRequireResolver map(ResolverProxy item) {
                    try {
                        return item.getResolver();
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
                        return null;
                    }
                }
            });
        }
        return fgProxies;
    }

    public static IPath resolve(String moduleId, final IProject project, final IPath currentDirectory, final IPath indexRoot) {
        List resolvers = CollectionsUtil.filter(RequireResolverFactory.getResolvers(), (IFilter)new IFilter<IRequireResolver>(){

            public boolean include(IRequireResolver item) {
                return item != null && item.applies(project, currentDirectory, indexRoot);
            }
        });
        for (IRequireResolver resolver : resolvers) {
            IPath path = resolver.resolve(moduleId, project, currentDirectory, indexRoot);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public static List<String> getPossibleModuleIds(final IProject project, final IPath currentDirectory, final IPath indexRoot) {
        List resolvers = CollectionsUtil.filter(RequireResolverFactory.getResolvers(), (IFilter)new IFilter<IRequireResolver>(){

            public boolean include(IRequireResolver item) {
                return item != null && item.applies(project, currentDirectory, indexRoot);
            }
        });
        for (IRequireResolver resolver : resolvers) {
            List<String> possible = resolver.getPossibleModuleIds(project, currentDirectory, indexRoot);
            if (CollectionsUtil.isEmpty(possible)) continue;
            return possible;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolverProxy
    implements Comparable<ResolverProxy> {
        private IConfigurationElement ice;
        private int priority;

        ResolverProxy(IConfigurationElement ice) {
            this.ice = ice;
            this.priority = -1;
        }

        IRequireResolver getResolver() throws CoreException {
            return (IRequireResolver)this.ice.createExecutableExtension("class");
        }

        synchronized int getPriority() {
            if (this.priority == -1) {
                try {
                    String pri = this.ice.getAttribute("priority");
                    this.priority = Integer.parseInt(pri);
                }
                catch (Exception e) {
                    this.priority = 50;
                }
            }
            return this.priority;
        }

        @Override
        public int compareTo(ResolverProxy o) {
            int thisVal = this.getPriority();
            int anotherVal = o.getPriority();
            return anotherVal - thisVal;
        }
    }
}

